/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.handlers.email;

import com.floragunn.signals.watch.action.handlers.email.EmailAccount;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.elasticsearch.SpecialPermission;
import org.simplejavamail.MailException;
import org.simplejavamail.email.Email;
import org.simplejavamail.mailer.Mailer;
import org.simplejavamail.mailer.MailerBuilder;
import org.simplejavamail.mailer.config.TransportStrategy;

public class SignalsMailer {
    private final EmailAccount emailDestination;
    private final Mailer mailer;

    public SignalsMailer(EmailAccount emailDestination) {
        this.emailDestination = emailDestination;
        String[] trustedHosts = new String[]{};
        if (this.sslUsed() && emailDestination.getTrustedHosts() != null) {
            trustedHosts = emailDestination.getTrustedHosts().toArray(new String[0]);
        }
        MailerBuilder.MailerRegularBuilder mailerBuilder = (MailerBuilder.MailerRegularBuilder)((MailerBuilder.MailerRegularBuilder)((MailerBuilder.MailerRegularBuilder)((MailerBuilder.MailerRegularBuilder)((MailerBuilder.MailerRegularBuilder)((MailerBuilder.MailerRegularBuilder)MailerBuilder.withSMTPServer((String)emailDestination.getHost(), (Integer)emailDestination.getPort(), (String)emailDestination.getUser(), (String)emailDestination.getPassword()).withProxy(emailDestination.getProxyHost(), emailDestination.getProxyPort(), emailDestination.getProxyUser(), emailDestination.getProxyPassword())).withDebugLogging(Boolean.valueOf(emailDestination.isDebug()))).withTransportModeLoggingOnly(Boolean.valueOf(emailDestination.isSimulate()))).withTransportStrategy(this.evalTransportStrategy()).trustingAllHosts(this.sslUsed() ? Boolean.valueOf(emailDestination.isTrustAll()) : Boolean.FALSE)).trustingSSLHosts(trustedHosts)).withProperty("mail.smtps.ssl.checkserveridentity", this.sslUsed() && (emailDestination.isTrustAll() || trustedHosts.length > 0) ? "false" : "true");
        if (emailDestination.getSessionTimeout() != null) {
            mailerBuilder.withSessionTimeout(emailDestination.getSessionTimeout());
        }
        this.mailer = mailerBuilder.buildMailer();
    }

    private boolean sslUsed() {
        return this.evalTransportStrategy() != TransportStrategy.SMTP;
    }

    private TransportStrategy evalTransportStrategy() {
        if (this.emailDestination.isEnableStartTls()) {
            return TransportStrategy.SMTP_TLS;
        }
        if (this.emailDestination.isEnableTls()) {
            return TransportStrategy.SMTPS;
        }
        return TransportStrategy.SMTP;
    }

    public void sendMail(final Email email) throws MailException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    ClassLoader originalContextClassoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    try {
                        SignalsMailer.this.mailer.sendMail(email);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalContextClassoader);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public void testConnection() {
        this.mailer.testConnection();
    }
}

